/*------------------------------------------------------------------------------*
 * File Name:netcdf_Utils.h	 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 06/11/08 v8.0882b FIX_NETCDF_LINKING_ERROR_CAUSE_BY_REMOVE_GETN_NEXT_PREV_DLG
 *------------------------------------------------------------------------------*/

#ifndef _NETCDF_UTILS_H_
#define _NETCDF_UTILS_H_

#include <oExtFile.h>

#define NC_MAX_VAR_DIMS 100 // max per variable dimensions, defined by netcdf


BOOL netcdf_1d_col(LPCSTR lpcszVar, Worksheet &wks, int iCol);

// Refer dim must be zero terminated, for example:
//  vector<int> vnRef = {1, 0}; // will read the 1st 2 dim data of 3D netcdf var
//  vector<int> vnRef = {4, 0}; // will read the 4th 2 dim data of 3D netcdf var
//  vector<int> vnRef = {1, 2, 0}; // will read the 2 dim data of 4D netcdf var
int netcdf_2d_mat(LPCSTR lpcszVar, MatrixLayer &matl, int nIndex, vector<int> &vnRef, int nType);

/**
	Read netcdf variable into a MatrixLayer
	Remark:
		netcdf file must be already open when calling this function, see netcdf_open
	Parameters:
		lpcszVar = [in] netcdf file variable name, support 2 or 3 or 4 dim variables
		matl = [in/out] MatrixLayer to read the data
		nMatObj1 = [in] Starting MatrixObject index to read data
		nMatObj2 = [in] Ending MatrixObject index to read data, if -1, then we will read to the size of the variable
		nDim = [in] index in the 4rd dimension to read if lpcszVar is more then 3 dimension 
*/
BOOL netcdf_xd_mat(LPCSTR lpcszVar, MatrixLayer &matl, int nDim = 0, int nMatObj1 = 0, int nMatObj2 = -1);

int import_netcdf_1d_into_wkssheet(Worksheet &wks, TreeNode &trVars);
int import_netcdf_into_matrix_sheet(MatrixPage &mo, string &strVar);
int import_netcdf(Page &pgTarget, LPCSTR lpcszFile, TreeNode &trFilter, int nFile);

int ImportNETCDF(Page &pgTarget, TreeNode &trFilter, LPCSTR lpcszFile, int nFile);

// This function will put the selected netcdf variable into tnFilter,
/// Hong 06/11/08 v8.0882b FIX_NETCDF_LINKING_ERROR_CAUSE_BY_REMOVE_GETN_NEXT_PREV_DLG
//BOOL netcdf_import_GetVarDialog(TreeNode& tnFilter, BOOL bGet1d = FALSE, BOOL bFromIW = FALSE);
BOOL netcdf_import_GetVarDialog(TreeNode& tnFilter, BOOL bGet1d = FALSE);
/// end FIX_NETCDF_LINKING_ERROR_CAUSE_BY_REMOVE_GETN_NEXT_PREV_DLG

// return < 0 means open file failed. otherwise return ncid
int OpenNetcdf(LPCSTR lpcszFile, TreeNode *ptrNCFile = NULL);

#endif // _NETCDF_UTILS_H_